package org.ksoap;


/** A class that is used to encapsulate primitive types
    (represented by a string in XML serialization). */



public class SoapPrimitive {

    
    String namespace;
    String name;
    String value;


    
    
    public SoapPrimitive (String namespace, String name, String value) {
	this.namespace = namespace;
	this.name = name;
	this.value = value;
    }


    public boolean equals (Object o) {
	if (!(o instanceof SoapPrimitive)) return false;

	SoapPrimitive p = (SoapPrimitive) o;
	
	return name.equals (p.name) && namespace.equals (p.namespace) &&
	    (value == null ? (p.value == null) : value.equals (p.value));
    }


    public int hashCode () {
	return name.hashCode () ^ namespace.hashCode ();
    }

    public String toString () {
	return value;
    }
    

    public String getNamespace () {
	return namespace;
    }


    public String getName () {
	return name;
    }

}
